# DLC Chatbot API and UI

This is a FastAPI-based application that provides both a web UI and API for the DLC Chatbot, which uses LangChain, Ollama, and MongoDB to provide a document-based Q&A system.

## Features

- Modern web-based chat interface
- REST API for integration with other applications
- Document-based question answering using LangChain and Ollama
- Session management for conversation continuity
- MongoDB integration for chat history persistence
- PDF, text file support with automatic vectorization

## Installation

1. Make sure you have Python 3.9+ installed
2. Install the required packages:

```bash
pip install langchain langchain-ollama langchain-community fastapi uvicorn pymongo pypdf jinja2
```

3. Install and run Ollama:
   - Follow the installation instructions at [ollama.ai](https://ollama.ai)
   - Pull the TinyLlama model: `ollama pull tinyllama`

4. Install and run MongoDB:
   - Install MongoDB from [mongodb.com](https://www.mongodb.com/try/download/community)
   - Start the MongoDB service

## Directory Structure

- `documents/` - Place your PDF and text files here
- `vectorstore_db/` - Storage for document embeddings (created automatically)
- `templates/` - HTML templates for the web interface
- `static/` - Static assets (CSS, JS) for the web interface
- `api.py` - FastAPI application with both UI and API endpoints
- `chatbot.py` - Command-line version of the chatbot

## Usage

### Running the Application

Start the FastAPI server with:

```bash
uvicorn api:app --reload --host 0.0.0.0 --port 8000
```

The application will be available at:
- Web UI: http://localhost:8000
- API Documentation UI: http://localhost:8000/api
- OpenAPI Documentation: http://localhost:8000/docs

### Web Interface

The web interface provides a user-friendly way to interact with the chatbot:

1. Open your browser and go to http://localhost:8000
2. Start typing questions in the chat input
3. Use the "New Chat" button to start a fresh conversation

### API Usage

The API can be used to integrate the chatbot into your applications:

1. Send a POST request to `/api/chat` with your question
2. Manage sessions with the sessions endpoints
3. Retrieve chat history for specific sessions

See the API documentation at http://localhost:8000/api for detailed information on all available endpoints.

## Adding Documents

1. Place your PDF or text files in the `documents/` directory
2. Restart the application - it will automatically detect and index new documents

## Customizing the Model

To use a different Ollama model, modify the model name in `api.py`:

```python
embedding = OllamaEmbeddings(model="your-model-name")
```

And update the chat function:

```python
response = ollama.chat(model="your-model-name", ...)
```

## Security Considerations

For production deployments, consider:

1. Adding proper authentication for API endpoints
2. Setting specific CORS origins instead of allowing all origins
3. Using environment variables for configuration
4. Setting up HTTPS with a proper certificate 